// Copyright (C) 2015 basysKom GmbH, opensource@basyskom.com
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QOPCUAATTRIBUTEOPERAND_H
#define QOPCUAATTRIBUTEOPERAND_H

#include <QtOpcUa/qopcuaglobal.h>
#include <QtOpcUa/qopcuatype.h>

#include <QtCore/qshareddata.h>

QT_BEGIN_NAMESPACE

class QOpcUaRelativePathElement;

class QVariant;
class QOpcUaRelativePathElement;

// OPC UA 1.05 part 4, 7.7.4.4
class QOpcUaAttributeOperandData;
class Q_OPCUA_EXPORT QOpcUaAttributeOperand
{
public:
    QOpcUaAttributeOperand();
    QOpcUaAttributeOperand(const QOpcUaAttributeOperand &);
    QOpcUaAttributeOperand &operator=(const QOpcUaAttributeOperand &);
    operator QVariant() const;
    ~QOpcUaAttributeOperand();

    QString nodeId() const;
    void setNodeId(const QString &nodeId);

    QString alias() const;
    void setAlias(const QString &alias);

    QList<QOpcUaRelativePathElement> browsePath() const;
    QList<QOpcUaRelativePathElement> &browsePathRef();
    void setBrowsePath(const QList<QOpcUaRelativePathElement> &browsePath);

    QOpcUa::NodeAttribute attributeId() const;
    void setAttributeId(QOpcUa::NodeAttribute attributeId);

    QString indexRange() const;
    void setIndexRange(const QString &indexRange);

private:
    friend Q_OPCUA_EXPORT bool comparesEqual(const QOpcUaAttributeOperand &lhs,
                                             const QOpcUaAttributeOperand &rhs) noexcept;
    friend bool operator==(const QOpcUaAttributeOperand &lhs,
                           const QOpcUaAttributeOperand &rhs) noexcept
    { return comparesEqual(lhs, rhs); }
    friend bool operator!=(const QOpcUaAttributeOperand &lhs,
                           const QOpcUaAttributeOperand &rhs) noexcept
    {
        return !(lhs == rhs);
    }

    QSharedDataPointer<QOpcUaAttributeOperandData> data;
};

QT_END_NAMESPACE

Q_DECLARE_METATYPE(QOpcUaAttributeOperand)

#endif // QOPCUAATTRIBUTEOPERAND_H
